<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Virtual extends CI_Controller {
    public function __construct() {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST");
        parent::__construct();
    }
    public function terms_and_conditions() {
        $this->load->view('virtual/terms-and-conditions');
    }

    public function privacy_policy() {
        $this->load->view('virtual/privacy-policy');
    }

    public function about_us() {
        $this->load->view('virtual/about-us');
    }

    public function how_to_list() {
        $this->load->view('virtual/how-to-list');
    }

    public function disclaimer() {
        $this->load->view('virtual/disclaimer');
    }

    public function limitations_of_liability() {
        $this->load->view('virtual/limitations-of-liability');
    }

    public function indemnification() {
        $this->load->view('virtual/indemnification');
    }

    public function signup() {
        $response = array("status" => 0, "message" => "Something went wrong, Please try again", "result" => new stdClass);
        try {
            $name = $this->input->post('name');
            $email = $this->input->post('email');
            $phone = $this->input->post('phone');
            $password = $this->input->post('password');
            $confirm_password = $this->input->post('confirm_password');
            $device = $this->input->post('device');
            $token = $this->input->post('token');
            if (!$name) { $response['message'] = "Please insert a name"; echo json_encode($response); die();}
            if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) { $response['message'] = "Please insert a valid email"; echo json_encode($response); die();}
            if (!$password) {$response['message'] = "Please insert a password"; echo json_encode($response);die();}
            if ($password !== $confirm_password) {$response['message'] = "Passwords do not match"; echo json_encode($response); die();}
            $existing_user = $this->db->where('email', $email)->get('v_user')->row();
            if ($existing_user) { $response['message'] = "Email already exists"; echo json_encode($response); die();}
            $md5_password = md5($password);
            $user_data = array('name' => $name,'email' => $email,'password' => $md5_password);
            if ($phone) {$user_data['phone'] = $phone;}            
            if ($device) { $user_data['device'] = $device;}            
            if ($token) {$user_data['token'] = $token;}
            $result = $this->db->insert('v_user', $user_data);
            if ($result) {
                $inserted_user_id = $this->db->insert_id();
                $response['status'] = 1;
                $response['message'] = "User Signup Successfully";
                $response['result'] = $this->db->where('id', $inserted_user_id)->get('v_user')->row();
            } else {
                $response['message'] = "Unable to signup";
            }
            echo json_encode($response);
            die();
        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            echo json_encode($response);
            die();
        }
    }

    public function login() {
        $response = array("status" => 0, "message" => "Invalid login credentials", "result" => new stdClass);
        try {
            $email = $this->input->post('email');
            $password = $this->input->post('password');
            $device = $this->input->post('device');
            $token = $this->input->post('token');
            if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) { $response['message'] = "Please insert a valid email"; echo json_encode($response); die();}
            if (!$password) {$response['message'] = "Please insert a password"; echo json_encode($response); die();}
            $md5_password = md5($password);
            $user = $this->db->where('email', $email)->where('password', $md5_password)->get('v_user')->row();
            if ($user) {
                $user_data = [];
                if ($device) {$user_data['device'] = $device;}                
                if ($token) {$user_data['token'] = $token;}                
                if($user_data){$this->db->where('email', $email)->update('v_user',$user_data);}
                $response['status'] = 1;
                $response['message'] = "Login successful";
                $response['result'] = $this->db->where('email', $email)->get('v_user')->row();
            } else {
                $response['message'] = "Invalid email or password";
            }
            echo json_encode($response);
            die();
        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            echo json_encode($response);
            die();
        }
    }

    public function forgot_password() {
        $response = array("status" => 0, "message" => "Something went wrong, Please try again", "result" => new stdClass);
        try {
            $email = $this->input->post('email');
            if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) {$response['message'] = "Please insert a valid email"; echo json_encode($response); die();}
            $user = $this->db->where('email', $email)->get('v_user')->row();
            if ($user) {
                $reset_code = rand(100000, 999999);
                $this->db->where('email', $email)->update('v_user', array('reset_code' => $reset_code));
                $subject = "Password Reset Code";
                $message = "Your password reset code is: " . $reset_code;
                mail($email, $subject, $message);
                $response['status'] = 1;
                $response['message'] = "Reset code sent to your email";
            } else {
                $response['message'] = "Email not found";
            }
            echo json_encode($response);
            die();
        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            echo json_encode($response);
            die();
        }
    }

    public function reset_password() {
        $response = array("status" => 0, "message" => "Something went wrong, Please try again", "result" => new stdClass);
        try {
            $email = $this->input->post('email');
            $reset_code = $this->input->post('reset_code');
            $new_password = $this->input->post('new_password');
            $confirm_password = $this->input->post('confirm_password');
            if (!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)) { $response['message'] = "Please insert a valid email"; echo json_encode($response); die();}
            if (!$reset_code) {$response['message'] = "Please insert the reset code"; echo json_encode($response); die(); }
            if (!$new_password) {$response['message'] = "Please insert a new password"; echo json_encode($response); die();}
            if ($new_password !== $confirm_password) {$response['message'] = "Passwords do not match"; echo json_encode($response); die();}
            $user = $this->db->where('email', $email)->where('reset_code', $reset_code)->get('v_user')->row();
            if ($user) {
                $hashed_password = md5($new_password);
                $this->db->where('email', $email)->update('v_user', array('password' => $hashed_password,'reset_code' => null ));
                $response['status'] = 1;
                $response['message'] = "Password reset successfully";
            } else {
                $response['message'] = "Invalid email or reset code";
            }
            echo json_encode($response);
            die();
        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            echo json_encode($response);
            die();
        }
    }
    public function reminder_add() {
        $response = array("status" => 0, "message" => "Something went wrong, Please try again", "result" => new stdClass);
        try {
            $user_id = $this->input->post('user_id');
            $document_name = $this->input->post('document_name');
            $expiration_date = $this->input->post('expiration_date');
            $reminder = $this->input->post('reminder');

            if (!$user_id) {$response['message'] = 'Please insert a user_id'; echo json_encode($response); die();}
            if (!$document_name) {$response['message'] = 'Please insert a document_name'; echo json_encode($response); die();}
            if (!$expiration_date) {$response['message'] = 'Please insert a expiration_date'; echo json_encode($response); die();}

            $data = array('user_id' => $user_id, 'document_name' => $document_name, 'expiration_date' => $expiration_date, 'reminder' => $reminder);

            if ($this->db->insert('v_reminders', $data)) {
                $response['status'] = 1;
                $response['message'] = 'Reminder added successfully';
            }else{
                $response['message'] = 'Unable to add reminder';
            }
            echo json_encode($response);
            die();
        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            echo json_encode($response);
            die();
        }
    }

    public function reminder_update() {
        $response = array("status" => 0, "message" => "Something went wrong, Please try again", "result" => new stdClass);
        try {
            $document_name = $this->input->post('document_name');
            $expiration_date = $this->input->post('expiration_date');
            $reminder = $this->input->post('reminder');
            $id = $this->input->post('id');

            if (!$id) { $response['message'] = "Please insert a reminder id"; echo json_encode($response); die();}
            if (!$document_name) { $response['message'] = "Please insert a document_name"; echo json_encode($response); die();}
            if (!$expiration_date) { $response['message'] = "Please insert a expiration_date"; echo json_encode($response); die();}

            $data = array( 'document_name' => $document_name, 'expiration_date' => $expiration_date, 'reminder' => $reminder);
            $this->db->where('id', $id);
            if ($this->db->update('v_reminders', $data)) {
                $response['status'] = 1;
                $response['message'] = 'Reminder updated successfully';
            }else{
                $response['message'] = 'Unable to update reminder';
            }
            echo json_encode($response);
            die();
        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            echo json_encode($response);
            die();
        }
    }

    public function reminder_notification_status() {
        $response = array("status" => 0, "message" => "Something went wrong, Please try again", "result" => new stdClass);
        try {
            $notification_status = $this->input->post('notification_status');
            $id = $this->input->post('id');

            if (!$id) { $response['message'] = "Please insert a reminder id"; echo json_encode($response); die();}

            $data = array( 'notification_status' => $notification_status);
            $this->db->where('id', $id);
            if ($this->db->update('v_reminders', $data)) {
                $response['status'] = 1;
                $response['message'] = 'Reminder notification status updated successfully';
            }else{
                $response['message'] = 'Unable to update reminder notification status';
            }
            echo json_encode($response);
            die();
        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            echo json_encode($response);
            die();
        }
    }

    public function reminder_delete() {
        $response = array("status" => 0, "message" => "Something went wrong, Please try again", "result" => new stdClass);
        try {
            $id = $this->input->post('id');
            if (!$id) {$response['message'] = 'Please insert a id'; echo json_encode($response); die();}
            $this->db->where('id', $id);
            if ($this->db->delete('v_reminders')) {
                $response['status'] = 1;
                $response['message'] = 'Reminder deleted successfully';
            }else{
                $response['message'] = 'Unable to delete reminder';
            }
            echo json_encode($response);
            die();
        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            echo json_encode($response);
            die();
        }
    }

    public function reminder_list() {
        $response = array("status" => 0, "message" => "Something went wrong, Please try again", "result" => new stdClass);
        try {
            $user_id = $this->input->post('user_id');
            if (!$user_id) {$response['message'] = 'Please insert a user_id'; echo json_encode($response); die();}
            $reminders = $this->db->where('user_id',$user_id)->order_by('id','DESC')->get('v_reminders')->result();
            if ($reminders) {
                $response['status'] = 1;
                $response['message'] = 'Reminder list fetched successfully ';                
                $response['result'] = $reminders;
            }else{
                $response['message'] = 'No record found';
            }
            echo json_encode($response);
            die();
        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            echo json_encode($response);
            die();
        }
    }

    public function notification_list() {
        $response = array("status" => 0, "message" => "Something went wrong, Please try again", "result" => new stdClass);
        try {
            $user_id = $this->input->post('user_id');
            if (!$user_id) {$response['message'] = 'Please insert a user_id'; echo json_encode($response); die();}
            $notifications = $this->db->where('user_id',$user_id)->order_by('id','DESC')->get('v_notifications')->result();
            if ($notifications) {
                $response['status'] = 1;
                $response['message'] = 'Notification list fetched successfully ';
                $response['result'] = $notifications;
            }else{
                $response['message'] = 'No record found';
            }
            echo json_encode($response);
            die();
        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            echo json_encode($response);
            die();
        }
    }

    public function notification_delete() {
        $response = array("status" => 0, "message" => "Something went wrong, Please try again", "result" => new stdClass);
        try {
            $id = $this->input->post('id');
            if (!$id) {$response['message'] = 'Please insert a id'; echo json_encode($response); die();}
            $this->db->where('id', $id);
            if ($this->db->delete('v_notifications')) {
                $response['status'] = 1;
                $response['message'] = 'Notification deleted successfully';
            }else{
                $response['message'] = 'Unable to delete notification';
            }
            echo json_encode($response);
            die();
        } catch (Exception $e) {
            log_message('error', $e->getMessage());
            echo json_encode($response);
            die();
        }
    }

    public function reminder_notification_send() {
        
        $all_users = $this->db->select('v_reminders.*, v_user.token')->from('v_reminders')->join('v_user', 'v_user.id = v_reminders.user_id')->where('v_reminders.notification_send', 0)->get()->result();
        foreach ($all_users as $user) {
            $givenDateTime = DateTime::createFromFormat('d-m-Y', $user->expiration_date);
            if (!$givenDateTime) { continue; }
            $currentDateTime = new DateTime();
            $daysDifference = $currentDateTime->diff($givenDateTime)->days;

            if (($daysDifference <= $user->reminder) && $user->token) {
                $postData = [
                    'message' => [
                        'token' => $user->token,
                        'data' => [
                            'title' => 'Reminder',
                            'body' => 'Your ' . $user->document_name . ' is expired soon.',
                            'type' => "reminder",
                            'is_read' => '0'
                        ],
                        'notification' => [
                            'title' => 'Reminder',
                            'body' => 'Your ' . $user->document_name . ' is expired soon.',
                        ]
                    ]
                ];
                if ($this->sendNotificationToHttp($postData)) {
                    echo "notification send to id".$user->id."<br>";
                    $this->db->insert('v_notifications',array('title' => 'Reminder', 'body' => 'Your ' . $user->document_name . ' is expired soon.', 'user_id' => $user->user_id, 'type' =>'reminder'));
                    $this->db->where('id', $user->id)->update('v_reminders', ['notification_send' => 1]);                    
                }
            }
        }
    }

    public function sendNotificationToHttp($data)
    {
        $key = [
            'project_id' => "myvirtualwallet-e472d",
            'client_email' => "firebase-adminsdk-qykrk@myvirtualwallet-e472d.iam.gserviceaccount.com",
            'private_key' => "-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCseHTVAkP8mlrt\na9NYgUzBLQYVO3fEmKeQHtXqXbzzlwbneOD9SrsqJrjZc2z3FAtzY8FOFNqHlddH\n+ip9M8Fs9COeDC7NkuxdLob39MUBO6927OA623sV9qHyGK8ZA4HaqUDVEKoTKcYg\nXlz2eL6lY71t5zyNm54TIQwRVIfbOKPwxv2vCL0fdfeIs93z+kT+umMyRZjcByvN\nUJTWQTCjnZsv4jR2jkOrkU6Ataf+ogQDV55I4ReL4LbBzni+Ep84p56DpimCHZSC\nXELJCJleGbOgIvqk2cSkIbenpju9QnSPHNxzd3/HVnzm9fQ2CXKeHTpldL2WB3Kw\neE0xaOIPAgMBAAECggEAAqOJZaLvEiPYc4djiJgvorsDAt61cpM1WuTexjvu0OP2\n1M0KY8W5qbXT2TTFLjNDXkE1+XFAILRje5CcQCXRhGsTLf1f1w8JJRudaV/qMUkj\nN6L89NmUuEEH1S5DnVnccSbAIJQzo0uIfshmYdXoVGLtOlLckdFs4liZCkfzibzS\nrbwQ/i4Q7cUjN36u8RryH8ADyXJ0izP7e+YUh7ZxOJwj/jtJ4TQsSnRpQTsS99QZ\ni+cOeMQsxiDQI4UhHNLgBwK3f4bBnGzJNcSitgU8uY5vGe0S2zID3oXDdlqhUWGo\nM/uYgUp7BSj7pHyZUzJlMXAtJWCDTh0ioL+1LLZrfQKBgQDxuEu4QfbDnh3Gjddl\nnCe23BeYZD5eSf9k/Ey6vR/gKWd0BR/qQYnA8PbtTIl+B6X3L4Y45C6mTJ4sRZ7x\nwvS3jjv/6J0nicvnfhchTPLsFtSYz2KUSV4QfESuQcxxuyAMDfSJqU2dD2YeGERf\n7+YRDTN9bbcpHzlbLdkwAnPUbQKBgQC2qNo6p5ACxDQKaMRjZ8BBrZ0xxfsljW2f\nunmfWIYT1EGLZIcdpOYPUAhVlF3tDo35gjxjA1/MYnECXXPF99fyY6q8ALzVwYaT\nGoVfqxo1sTzaKOLr7Tlr4W+vWC64Hq2gjQJ4bv67BnVoAZC8SAZunW2Nptp3zyfi\nH9UEXkcq6wKBgCNuBfs9//NwS6D8zWOhXdjZrcOyfcnIQt0EdiKw8ekjaHyC+8iU\nTqKvLyJdI5ILgPIYTy4rlALgHBcVJVT+ZGw7NuQtrktLUU3fF3jUFI8yUXsMesCN\neHImJNL95f+NlAbwTLWY0T2CMk+a8vq06R36t19dI4mtf/SzZbA5y8yJAoGANhWH\nEGj+9iK8OfzNcZWN0qSib9NsSrE2rV3clzbx9Dsb8Tch3sAtsokC/rwAl6mAlkle\nsf6UxgK77XRYTFzXXxjtu98ICs7Tlwj6Rtp110IUf5AtqKfEIdJNbIDSzIeg53H5\nMknDOQNvjg0wmt9EsEoC3zdxZpo69/Ru8W0s62MCgYEA3Z/KAzLR92/zgtGHwjd3\nibNGuBIFAB5cCH88k82JCFbyeDem5TaCQyJDN/5S1ZU26zpA/R2HY8yX/gvQteEM\nRnK+MNuQlikPX1nlzGckmwZFoz43f90ZysLK0Letii7vBSBgSd/tneXvEEvyY+N2\nUsl1wJ2NzRUB5GbCiLuCYwM=\n-----END PRIVATE KEY-----\n",
        ];
        if (isset($key['project_id'])) {
            $url = 'https://fcm.googleapis.com/v1/projects/' . $key['project_id'] . '/messages:send';
            $headers = [
                'Authorization: Bearer ' . $this->getAccessToken($key),
                'Content-Type: application/json',
            ];
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            $response = curl_exec($ch);
            if (curl_errno($ch)) {
                return false;
            }
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            if ($httpCode === 200) {
                return $response; 
            } else {
                return false;
            }
        }        
    }

    public function getAccessToken($key)
    {
        $jwtToken = [
            'iss' => $key['client_email'],
            'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
            'aud' => 'https://oauth2.googleapis.com/token',
            'exp' => time() + 3600,
            'iat' => time(),
        ];
        $jwtHeader = base64_encode(json_encode(['alg' => 'RS256', 'typ' => 'JWT']));
        $jwtPayload = base64_encode(json_encode($jwtToken));
        $unsignedJwt = $jwtHeader . '.' . $jwtPayload;
        openssl_sign($unsignedJwt, $signature, $key['private_key'], OPENSSL_ALGO_SHA256);
        $jwt = $unsignedJwt . '.' . base64_encode($signature);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://oauth2.googleapis.com/token');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
            'assertion' => $jwt,
        ]));
        $response = curl_exec($ch);
        if (curl_errno($ch)) {
            return null;
        }
        curl_close($ch);
        return json_decode($response, true)['access_token'] ?? null;
    }
    
}