<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Streaming extends CI_Controller {
    public function __construct() {
		header('Access-Control-Allow-Origin: *');
	    header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
	    header("Access-Control-Allow-Methods: GET, POST");
	    parent::__construct();
	}
	public function getChats(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$roomId = $this->input->post('roomId');
			$lastChatId = $this->input->post('lastChatId');
			if(!$roomId){$response['message']="Please insert a room Id";echo json_encode($response); die();}
			if($lastChatId){
			    $chats = $this->db->where('roomId',$roomId)->where("id > '".$lastChatId."'")->get('s_chat')->result();
			}else{
			    $chats = $this->db->where('roomId',$roomId)->get('s_chat')->result();
			}
			
			if($chats){
				$response['status'] = 1;
				$response['message'] = "Chat fetched Successfully";
				$response['streamFlag'] = $this->db->where('roomId',$roomId)->get('sn_room')->row()->streamingFlag; 
				$response['result'] = $chats;
			}else{
			    $response['status'] = 0;
				$response['message'] = "No New messages";
				$response['streamFlag'] = $this->db->where('roomId',$roomId)->get('sn_room')->row()->streamingFlag;
				$response['result'] = $chats;
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function sentMessage(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
		    date_default_timezone_set('Asia/Kolkata');
			$roomId = $this->input->post('roomId');
			$userId = $this->input->post('userId');
			$userName = $this->input->post('userName');
			$text = $this->input->post('text');

			if(!$roomId){$response['message']="Please insert a room Id";echo json_encode($response); die();}
			if(!$text){$response['message']="Please insert a text";echo json_encode($response); die();}
			if(!$userName){$response['message']="Please insert a user name";echo json_encode($response); die();}
			
			$this->db->insert('s_chat',array('roomId'=>$roomId,'userId'=>$userId,'text'=>$text,'userName'=>$userName,'created_at'=>date('Y-m-d H:i:s'),'updated_at'=>date('Y-m-d H:i:s')));
			$chats = $this->db->where('roomId',$roomId)->get('s_chat')->result();
			if($chats){
				$response['status'] = 1;
				$response['message'] = "Chat fetched Successfully";
				$response['result'] = $chats;
			}else{
				$response['message'] = "No Data Inserted";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function createRoom(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$roomId = $this->input->post('roomId');

			if(!$roomId){$response['message']="Please insert a room Id";echo json_encode($response); die();}
			$this->db->insert('s_room',array('roomId'=>$roomId));
			$id = $this->db->insert_id();
			if($id){
				$response['status'] = 1;
				$response['message'] = "room created Successfully";
				$response['result'] = $id;
			}else{
				$response['message'] = "No Data Inserted";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function roomLog(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$roomId = $this->input->post('roomId');
			$log = $this->input->post('log');


			if(!$roomId){$response['message']="Please insert a room Id";echo json_encode($response); die();}
			if(!$log){$response['message']="Please insert a log";echo json_encode($response); die();}
			$this->db->insert('s_room_log',array('roomId'=>$roomId,'log'=>$log));
			$roomlog = $this->db->where('roomId',$roomId)->get('s_room_log')->result();

			if($roomlog){
				$response['status'] = 1;
				$response['message'] = "room log Successfully save";
				$response['result'] = $roomlog;
			}else{
				$response['message'] = "No Data Inserted";
			} 
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function getRoomLog(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$roomId = $this->input->post('roomId');
			if(!$roomId){$response['message']="Please insert a room Id";echo json_encode($response); die();}
			$roomlog = $this->db->where('roomId',$roomId)->get('s_room_log')->result();
			if($roomlog){
				$response['status'] = 1;
				$response['message'] = "room log Successfully save";
				$response['result'] = $roomlog;
			}else{
				$response['message'] = "No Data Inserted";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function createRoomId(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$title = $this->input->post('title');
			$description = $this->input->post('description');
			$name = $this->input->post('name');

			if(!$title){$response['message']="Please insert a title";echo json_encode($response); die();}
			if(!$description){$response['message']="Please insert a description";echo json_encode($response); die();}
			if(!$name){$response['message']="Please insert a name";echo json_encode($response); die();}
			$generateRoomId = $this->generate_unique_room_id();
			$this->db->insert('sn_room',array('title'=>$title,'description'=>$description,'name'=>$name,'roomId'=>$generateRoomId));
			$id = $this->db->insert_id();
			if($id){
			    $data = $this->db->where('id',$id)->get('sn_room')->row();
				$response['status'] = 1;
				$response['message'] = "room created Successfully";
				$response['result'] = $data;
			}else{
				$response['message'] = "No Data Inserted";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	private function generate_unique_room_id() {
        do {
            $room_id = mt_rand(100000, 999999);
            $existing_room = $this->db->get_where('sn_room', array('roomId' => $room_id))->row();
        } while ($existing_room);
        return $room_id;
    }
    public function updateRoomDetail(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$hostId = $this->input->post('hostId');
			$hostStream = $this->input->post('hostStream');
			$streamingFlag = $this->input->post('streamingFlag');
			$roomId = $this->input->post('roomId');
			if(!$hostId){$response['message']="Please insert a host Id";echo json_encode($response); die();}
			if(!$roomId){$response['message']="Please insert a room Id";echo json_encode($response); die();}	
			if(!$hostStream){$response['message']="Please insert a host stream";echo json_encode($response); die();}
			if(!$streamingFlag){$response['message']="Please insert a streaming flag";echo json_encode($response); die();}
			
			$this->db->where('roomId',$roomId)->update('sn_room',array('hostId'=>$hostId,'hostStream'=>$hostStream,'streamingFlag'=>$streamingFlag));
			$data = $this->db->where('roomId',$roomId)->get('sn_room')->row();
			if($data){
				$response['status'] = 1;
				$response['message'] = "room updated Successfully";
				$response['result'] = $data;
			}else{
				$response['message'] = "No Data updated";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function joinRoom(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$roomId = $this->input->post('roomId');
			$userId = $this->input->post('userId');
			$userName = $this->input->post('userName');

			if(!$userId){$response['message'] = "Please insert a user Id";echo json_encode($response); die();}
			if(!$roomId){$response['message'] = "Please insert a room Id";echo json_encode($response); die();}
			if(!$userName){$response['message'] = "Please insert a user name";echo json_encode($response); die();}
			$roomStatus = $this->db->where('roomId',$roomId)->get('sn_room')->row();
			if(!$roomStatus){
			    $response['message'] = "Invalid Room Id";echo json_encode($response); die();
			}else if($roomStatus->streamingFlag == 'end'){
			    $response['message'] = "Streaming End";echo json_encode($response); die();
			}
			if(!$userName){$response['message'] = "Please insert a user name";echo json_encode($response); die();}

			$this->db->insert('sn_room_join',array('roomId'=>$roomId,'userId'=>$userId,'userName'=>$userName));
			if($roomId){
				$data['hostData'] = $this->db->where('roomId',$roomId)->get('sn_room')->row();
				$data['guestData'] = $this->db->where('roomId',$roomId)->get('sn_room_join')->result();
				$response['status'] = 1;
				$response['message'] = "user join a room Successfully";
				$response['result'] = $data;
			}else{
				$response['message'] = "No Data updated";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function leftRoom(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$roomId = $this->input->post('roomId');
			$userId = $this->input->post('userId');

			if(!$userId){$response['message'] = "Please insert a user Id";echo json_encode($response); die();}
			if(!$roomId){$response['message'] = "Please insert a room Id";echo json_encode($response); die();}

			$this->db->where(array('roomId'=>$roomId,'userId'=>$userId))->delete('sn_room_join');
			if($roomId){
				$data['hostData'] = $this->db->where('roomId',$roomId)->get('sn_room')->row();
				$data['guestData'] = $this->db->where('roomId',$roomId)->get('sn_room_join')->result();
				$response['status'] = 1;
				$response['message'] = "user left a room Successfully";
				$response['result'] = $data;
			}else{
				$response['message'] = "No Data updated";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function roomDetails(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$roomId = $this->input->post('roomId');
			if(!$roomId){$response['message'] = "Please insert a room Id";echo json_encode($response); die();}
			$data['hostData'] = $this->db->where('roomId',$roomId)->get('sn_room')->row();
			$data['guestData'] = $this->db->where('roomId',$roomId)->get('sn_room_join')->result();
			if($roomId){
				$response['status'] = 1;
				$response['message'] = "room data fetched Successfully";
				$response['result'] = $data;
			}else{
				$response['message'] = "No Data fetch data";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function getQuestions(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
		    $questions = $this->db->order_by('id','DESC')->get('s_poll_question')->result();
			if($questions){
				foreach($questions as $question){
				    $question->options = $this->db->where('questionId',$question->id)->get('s_poll_options')->result();
				}
				$response['status'] = 1;
				$response['message'] = "Poll questions";
				$response['result'] = $questions;
			}else{
				$response['message'] = "No Data fetched";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function activatePoll(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$roomId = $this->input->post('roomId');
			if(!$roomId){$response['message'] = "Please insert a room Id";echo json_encode($response); die();}
			$questionId = $this->input->post('questionId');
			if(!$questionId){$response['message'] = "Please insert a question Id";echo json_encode($response); die();}
			$status = $this->input->post('status');
			if(!$status){$status = "activate";}
			$this->db->where('roomId',$roomId)->delete('s_room_poll');
			$this->db->where('roomId',$roomId)->delete('s_room_poll_answer');
			if($status == 'activate'){
			    $result = $this->db->insert('s_room_poll',array('roomId'=>$roomId,'questionId'=>$questionId,'status'=>1));
			    if($result){
			        $questions = $this->db->where('id',$questionId)->get('s_poll_question')->row();
    				$questions->options = $this->db->where('questionId',$questions->id)->get('s_poll_options')->result();
    				$response['status'] = 1;
    				$response['message'] = "Poll question activated Successfully";
    				$response['result'] = $questions;
			    }else{
			       $response['message'] = "Unable to activated poll question"; 
			    }
			}else{
			    $response['status'] = 1;
				$response['message'] = "Poll question Deactivated Successfully";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function getActivatePollQuestion(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$roomId = $this->input->post('roomId');
			if(!$roomId){$response['message'] = "Please insert a room Id";echo json_encode($response); die();}
		
			$result = $this->db->where(array('roomId'=>$roomId,'status'=>1))->get('s_room_poll')->row();
			if($result){
			    $questions = $this->db->where('id',$result->questionId)->get('s_poll_question')->row();
				$options = $this->db->where('questionId',$questions->id)->get('s_poll_options')->result();
				
				foreach($options as $qo){
				    $qo->resultCount = $this->db->where(array('roomId'=>$roomId,'questionId'=>$questions->id,'options'=>$qo->id))->count_all_results('s_room_poll_answer');
				}
				$questions->options = $options;
				$response['status'] = 1;
				$response['message'] = "Active Poll Question fetched successfully";
				$response['result'] = $questions;
			}else{
				$response['message'] = "Unable to fetched activated poll question";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function storePollAnswer(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
			$roomId = $this->input->post('roomId');
			$questionId = $this->input->post('questionId');
			$userId = $this->input->post('userId');
			$userName = $this->input->post('userName');
			$options = $this->input->post('options');

			if(!$roomId){$response['message'] = "Please insert a room Id";echo json_encode($response); die();}
			if(!$questionId){$response['message'] = "Please insert a questionId";echo json_encode($response); die();}
			if(!$userId){$response['message'] = "Please insert a userId";echo json_encode($response); die();}
			if(!$userName){$response['message'] = "Please insert a userName";echo json_encode($response); die();}
			if(!$options){$response['message'] = "Please insert a options";echo json_encode($response); die();}
			
			$result = $this->db->insert('s_room_poll_answer',array('roomId'=>$roomId,'questionId'=>$questionId,'userId'=>$userId,'userName'=>$userName,'options'=>$options));

			if($result){
				$response['status'] = 1;
				$response['message'] = "Answer Submited by ";
			}else{
				$response['message'] = "Unable to activated poll question";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	public function getStreamRecording(){
		$response = array("status"=>0,"message"=>"Something went wrong, Please try again","result"=>new stdClass);		
		try{
            $records = $this->db->where('streamingFlag', 'end')->order_by('created_at', 'DESC')->get('sn_room')->result();
            // https://stream.vuyu.online/LiveApp/streams/123331_720p2000kbps.mp4
            $modified_records = array_map(function($record) use ($base_url) {
                $record->recordingUrl = 'https://stream.vuyu.online/LiveApp/streams/' . $record->roomId . '_720p2000kbps.mp4';
                return $record;
            }, $records);
			if($records){
				$response['status'] = 1;
				$response['message'] = "Data fetched Successfully";
				$response['result'] = $records;
			}else{
				$response['message'] = "No Data fetched";
			}
			echo str_replace(':null',':""',json_encode($response)); die();
		}catch (Exception $e) {
			echo json_encode($response); die();
		}
	}
	
}